# Image Optimization by Optimole - Lazy Load, CDN, Convert WebP & AVIF #
**Contributors:** [optimole](https://profiles.wordpress.org/optimole/)  
**Tags:** image optimization, convert webp, image optimizer, lazy load, image, optimization, convert AVIF, resize, free cdn, compress images, optimize images  
**Requires at least:** 5.5  
**Tested up to:** 6.7  
**Requires PHP:** 7.4  
**Stable tag:** 3.14.1  
**License:** GPLv3  
**License URI:** https://www.gnu.org/licenses/gpl-3.0.en.html  

Automatically compress, optimize and serve scaled images as well as convert WebP & AVIF all from CloudFront CDN. Lazy load included ⚡

## Description ##

Optimole is the all-in-one solution to all of your image optimization needs. With full automation and a range of evolutionary features, Optimole makes it easy to clean up your heavy images and bloaty pages.

🤔 Not sure? Test the Magic of Optimole - [Scan your website](https://optimole.com/test-drive/?utm_source=wpadmin&utm_medium=readme&utm_campaign=optimole) to see how we can help.

Optimole [optimizes](https://www.codeinwp.com/blog/how-to-optimize-images/) your images in real-time with a cloud-based system to [speed up your website](https://optimole.com/website-speed-optimization-and-how-to-speed-up-wordpress/) and deliver high-quality images perfectly sized for every device. With a one-click setup and minimal footprint, you can start improving your site in minutes.

### What makes Optimole so special?

- Smaller images. Same quality
- Fully automated; [set and forget](https://docs.optimole.com/article/1173-how-to-get-started-with-optimole-in-just-3-steps)
- Supports all image types
- Supports both Retina and WebP images
- Machine Learning(ML) powered automatic compression
- AVIF format support for lower image size
- Streamline your media with Optimole's custom DAM (Digital asset Management) solution
- Cloud image library support
- Edit images in the cloud library before inserting them into your website
- Serves images from a global CDN for free
- Optimizes based on the visitor's actual device (no more guesswork and width estimations)
- Full support for page builders like Elementor
- Lazy load without jQuery (better)
- Add a splash of color to your lazy-loading placeholder
- Hero image optimization for speedier loads
- Boost WooCommerce gallery performance with Optimole's lazy-loading
- More file types in the dashboard (video, audio, documents and more)
- Fully functional free version (we have [paid plans](https://optimole.com/pricing/?utm_source=wpadmin&utm_medium=readme&utm_campaign=optimole) as well)

You'll be free to concentrate on other aspects of your site with Optimole's set and forget image optimization.

So, if you have been looking for one plugin that provides lazy loading with a CDN and perfectly sized images, then Optimole is perfect for you.

### Checkout a quick overview of Optimole plugin
https://youtu.be/siCm0fhNes0

### How does it do all these great things?

Optimole's format-based optimization is handled in the cloud on a case-by-case basis. Once you have the plugin installed, Optimole will replace all of your image URLs with cloud-based URLs. We don't replace any images on your website, we compress images on the fly.

When the image is requested, Optimole will apply the specific transformations required by the device and deliver it to your visitors. This means every image is perfectly sized for every device. The final result will be cached for a month to ensure ongoing fast delivery and more site speed.

### How many images can be optimized?

With the basic plan, you will be able to optimize an unmetered number of images for up to 1k monthly [visits](https://docs.optimole.com/article/1134-how-optimole-counts-the-number-of-visitors). All are delivered from more than 450+ locations around the globe.

Better yet. The free version is fully functional and includes all of the following great features:

#### Format-Based Optimization

Our cloud-based transformation process means we can optimize images based on the format as well as serve images in next-gen formats. If your visitor is using a WebP-capable browser, then Optimole will convert to WebP the image and send it to their device. AVIF support included.

#### Cloud Library support

Offload your website images directly to Optimole Cloud and save storage space on your server. Cross-share images between all your websites connected to Optimole.

#### Image Optimization

Our algorithms crunch the numbers to provide the best lossy or lossless optimization for the best-looking image at the smallest size using Machine Learning(ML) powered compression.

#### Digital Assets Management (DAM)

Elevate your media management with our custom DAM and utilize images from your Optimole account. The best part? You can now directly incorporate images from your Optimole account into the Elementor Builder. Additionally, we've seamlessly integrated DAM with the WordPress core editor, making image management a breeze. Access your Optimole images effortlessly, wherever you need them.

#### Exact Used Size

Optimole will use just one image and resize it delivering a responsive image to fit perfectly on your visitors' devices. No more awkward guesses at potential screen widths. Serve scaled images instantly.

#### Retina Support

Optimole can detect Retina screens and deliver an image with the perfect Device Pixel Ratio (DPR).

#### Smart Cropping

If you'd like to keep the most interesting part of an image; then you can enable smart cropping to help keep the image well-sized without losing focus.

>**Use Case:** Introducing Lisa, a lifestyle blogger who loves sharing her adventures through captivating visuals. With Optimole's Smart Cropping, Lisa's images are automatically resized to fit perfectly within her post layouts. Whether it's a breathtaking mountain landscape or a cosy café scene, Smart Cropping ensures every image tells its story without any hassle. Lisa's blog now shines with effortlessly framed images that capture every moment beautifully.

#### No Content Shifting

The lazy load option defers offscreen images and is perfectly sized for the container to provide a seamless viewing experience without any content shifting.

#### Watermarks

Who has time for adding watermarks? Optimole will do the hard work for you. Just set it up and pick your preferred location and Optimole will add the watermark to all of your future images.

>**Use Case:** Meet John, a passionate photographer with a growing online gallery. Adding watermarks used to be a hassle—until Optimole stepped in. Now, John can easily add watermarks to any or all of his images with just a few clicks. He can adjust the size, position, and much more. 

#### Downgrade Quality For Slower Connections

Optimole provides an option to downgrade the image quality when it detects a slower network. Efficiently encode images by making up to 40% smaller with this neat feature to help visitors in a bottleneck.

#### Compatibility

Optimole loves page builders and has unique tweaks to solve image replacements. It also has full compatibility with the new block editor since WordPress 5.0

#### CDN

Optimole provides free access to an AWS CloudFront CDN with edge locations in more than 450+ cities around the globe.

>**Use Case:** Meet Alex, an online store owner reaching customers globally. With Optimole's CDN, his product images are effortlessly spread across AWS CloudFront's 450+ global edge locations. This means shoppers from Tokyo to New York enjoy super-fast page loads, ensuring a seamless shopping experience and boosting Alex's business success.

#### Custom Lazy Load Placeholder Color

Optimole enhances your lazy-loading experience by allowing for customizable placeholder colors. Now your placeholders can be as unique as your website.

#### More File Types

No longer confined to just images — Optimole Dashboard now supports uploads for a variety of file types like documents, videos, text, and audio, widening your media capabilities.

### What About Security?

The stripped EXIF data is not stored on our service. Optimole likes to work behind the scenes, and won't interact with your site's visitors. No data is collected but you can check the [Terms of Service](https://optimole.com/terms/)

### Smooth And Clean

Optimole can be installed in a few clicks and then left in the back end to do its job. Not happy with it? Optimole has a clean uninstall and your site will be just as before Optimole was installed.

### Go Pro 🚀

Premium users will be able to optimize images starting with more than 40k monthly active users. Images in the Premium plan are served from AWS Cloudfront with over 450+ locations all over the world. Explore more features of [Optimole Pro](https://optimole.com/pricing/?utm_source=wpadmin&utm_medium=readme&utm_campaign=optimole).

### Support 🤝

We're here to help. Feel free to open a new thread on the [Support Forum](https://wordpress.org/support/plugin/optimole-wp/).

### Documentation 📚

Discover how to make the most of Optimole with our detailed and user-friendly [documentation](https://docs.optimole.com/).

## Screenshots ##

1. Connect API
2. General Settings
3. Advance Settings
4. Cloud Library
5. Cloud Storage

## Changelog ##

##### [Version 3.14.1](https://github.com/Codeinwp/optimole-wp/compare/v3.14.0...v3.14.1) (2025-02-21)

- Improve error handling on connection
- Fixes sub-API keys displaying the site selector in Cloud Library settings




[See changelog for all versions](https://github.com/Codeinwp/optimole-wp/blob/master/CHANGELOG.md).


## Installation ##
The following are the steps to install the OptiMole plugin

1. In your WordPress Administration Panels, click on Add New option under Plugins from the menu.
Click on upload at the top.
2. Browse the location and select the OptiMole Plugin and click install now.
3. Go to Media -> OptiMole and follow in the instructions on how to enable the service.

## Frequently Asked Questions ##

### How many images I can optimize with each plan? ###

The number of images that you can optimize or store is unlimited, we care only about the number of visits you have per month.

### What happens if I exceed plan limits? ###

Once you exceed these, we will contact you and kindly ask to upgrade to the plan that fits you best.

### What Content Delivery Network (CDN) do you use? ###

For both FREE and Paid plans we use AWS CloudFront CDN with more than 450 locations around the globe.

### I'm already using a CDN, can I use that instead of yours ? ###

Short answer, YES. You will only need to whitelist the domain of your existing CDN for Optimole to pick images stored there.

### I'm already using an image optimization plugin, why should I switch to Optimole? ###

You don’t need to change your existing optimization plugin, image optimization is just a small part of what we do, if you are happy with ShortPixel for e.g, feel free to continue to use it, Optimole would then take care only of serving your image at the RIGHT size, advanced cropping and smart lazy-loading.

### Does Optimole handle images from Ajax content ? ###

Yes, we do. By default, Optimole handle images delivered from your ajax content from admin-ajax.php ( not logged in users ) as well as WordPress REST API routes.

### Can I remove the blurry placeholder from the lazyload effect ? ###

Yes, you can. You only need to toggle this feature in the plugin as explained per this doc - https://docs.optimole.com/article/1020-can-i-remove-the-blurry-placeholder-from-the-lazyload-effct

### Will the original images be deleted? ###

We use your original images as sources when deliver the optimized images. Unless you want to remove images from your server to save some space with Cloud Library by offloading images to the cloud as explained here - https://docs.optimole.com/article/1323-cloud-library-browsing

### What is the difference between the Auto, High, Medium, Low compression levels? ###

A higher compression might result in a small loss of image quality. Selecting the auto level will let Optimole choose the minimum size with no loss in the quality of your picture.

### I used Kraken, Shortpixel, Optimus, EWWW or WP Smush, Imagify will Optimole further optimize my images? ###

Yes, Optimole will also take care of serving your image at the RIGHT size for your visitors and optimize them to the best possible format for their browser.

### Which formats can be optimized ? ###

For now we support jpg, png and svg format.

### Does Optimole automatically serve WebP for Chrome users ? ###

Yes. We automatically detect user browser and serve WebP if is supported, otherwise we optimize the image in the original format.

### Can I disable lazyload for PNG images ? ###

Yes. You need to add `define("OPTML_DISABLE_PNG_LAZYLOAD",true);` to `your wp-config.php` file.

You can also use plugin's UI and exclude images by their type as explained here - https://docs.optimole.com/article/1191-exclude-from-optimizing-or-lazy-loading

### Can I disable optimization for a certain image ? ###

Yes, you can exclude certain image by its name as explained here - https://docs.optimole.com/article/1191-exclude-from-optimizing-or-lazy-loading

In case you're tech-savvy and want programatically exclude images by some conditions you can follow this code snippet and replace the sample image with the one you need or have other conditions:

<code>
add_filter('optml_dont_replace_url', function( $old, $url ) {
	if ( $url === 'https://example.com/wp-content/uploads/2018/09/1.jpg' ) {
		return true;
	}
	return $old;

}, 10, 2);
</code>
